/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * graph.h
 * Copyright (C) Mike Crash 2008 <mike@mikecrash.com>
 *
 * main.cc is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * main.cc is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GOT_SCAN_H
#define GOT_SCAN_H

#include <stdio.h>
#include <stdlib.h>
#include <glibmm.h>
#include "scsi_command.h"
#include "scsi_mmc.h"
#include "drive_tools.h"

#define SCMD_NONE  0
#define SCMD_PAUSE 10
#define SCMD_STOP  11

#define SSTAT_NONE   0
#define SSTAT_INIT   1
#define SSTAT_SPINUP 2
#define SSTAT_START  3
#define SSTAT_ABORT  4
#define SSTAT_DONE   5
#define SSTAT_UPDATE 6

class CScan
{
public:
	CScan();
	~CScan();

    int  id() const;
    bool unfinished() const;

    void run();
    void join();
    void stop();
    sigc::signal<void>& signal_finished();
	//void skip_test();
	//void abort_test();
    void set_drive(drive_info* drv);
    int get_count(void);
    int get_size(void);
    int get_limit(void);
    void set_size(int sz);
    float get_max_x(void);
    float get_max_y(void);
    float* get_buffer(void);

    float get_start1(void);
    float get_start2(void);
    float get_end1(void);
    float get_end2(void);
    float get_avg1(void);
    float get_avg2(void);
    int   get_scantime(void);
    
    //signals
    int                 signal_status;
    Glib::Dispatcher    signal_dispatcher;

protected:
    Glib::Thread*       thread_;
    int                 id_;
    
    drive_info*         drive;
    int                 cmd;
    bool                stop_;

    int                 count;   //count of data in buffer
    int                 size;    //size of buffer
    int                 limit;   //this is limit in buffer
    float               max_x;   //maximum value unit in MB
    float               max_y;   //maximum result in 
    int                 bufsize;
    float*              buffer;
    
    float               start1;
    float               start2;
    float               end1;
    float               end2;
    float               avg1;
    float               avg2;
    int                 scantime;

    void signal(int status);
    void thread_function();
    virtual void test() { };
};


#endif // GOT_SCAN_H
