/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * main_window.h
 * Copyright (C) Mike Crash 2008 <mike@mikecrash.com>
 *
 * main.cc is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * main.cc is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MAIN_WINDOW_H_INCLUDED
#define MAIN_WINDOW_H_INCLUDED 1

#include <gtkmm.h>
#include "graph.h"
#include "drive_tools.h"
#include "scan.h"

class TracksColumns : public Gtk::TreeModelColumnRecord
{
public:
  TracksColumns()
    { add(col_track); add(col_type); add(col_size); add(col_begin); add(col_end); }
  Gtk::TreeModelColumn<Glib::ustring> col_track;
  Gtk::TreeModelColumn<Glib::ustring> col_type;
  Gtk::TreeModelColumn<Glib::ustring> col_size;
  Gtk::TreeModelColumn<Glib::ustring> col_begin;
  Gtk::TreeModelColumn<Glib::ustring> col_end;
};

struct MainWindow : public Gtk::Window
{
private:
    bool suspend;
    //Glib::RefPtr<Gnome::Glade::Xml> refXml;
    Gtk::ToolButton *button_start;
    Gtk::ToolButton *button_stop;
    Gtk::ToolButton *button_eject;
    Gtk::ComboBoxText *combo_drive;
    Gtk::CheckButton *check_locked;
    //drive
    Gtk::Label *info_vendor;
    Gtk::Label *info_model;
    Gtk::Label *info_firmware;
    Gtk::Label *info_buffer;
    Gtk::Label *info_tla;
    Gtk::Label *info_sn;
    Gtk::Label *info_iface;
    Gtk::Label *info_loader;
    Gtk::Label *info_rpc;
    Gtk::Label *info_region;
    Gtk::Label *info_userchng;
    Gtk::Label *info_vendorrst;
    Gtk::Image *info_cdr_r;
    Gtk::Image *info_cdr_w;
    Gtk::Image *info_cdrw_r;
    Gtk::Image *info_cdrw_w;
    Gtk::Image *info_ddcdr_r;
    Gtk::Image *info_ddcdr_w;
    Gtk::Image *info_ddcdrw_r;
    Gtk::Image *info_ddcdrw_w;
    Gtk::Image *info_mrain_r;
    Gtk::Image *info_mrain_w;
    Gtk::Image *info_dvdrom_r;
    Gtk::Image *info_dvdram_r;
    Gtk::Image *info_dvdram_w;
    Gtk::Image *info_dvdrm_r;
    Gtk::Image *info_dvdrm_w;
    Gtk::Image *info_dvdrwm_r;
    Gtk::Image *info_dvdrwm_w;
    Gtk::Image *info_dvdrdlm_r;
    Gtk::Image *info_dvdrdlm_w;
    Gtk::Image *info_dvdrp_r;
    Gtk::Image *info_dvdrp_w;
    Gtk::Image *info_dvdrwp_r;
    Gtk::Image *info_dvdrwp_w;
    Gtk::Image *info_dvdrdlp_r;
    Gtk::Image *info_dvdrdlp_w;
    Gtk::Image *info_removable;
    Gtk::Image *info_embchanger;
    Gtk::Image *info_sidechange;
    Gtk::Image *info_audiocdplay;
    Gtk::Image *info_composite;
    Gtk::Image *info_digital1;
    Gtk::Image *info_digital2;
    Gtk::Image *info_multisession;
    Gtk::Image *info_mode2form1;
    Gtk::Image *info_mode2form2;
    Gtk::Image *info_isrcread;
    Gtk::Image *info_upcread;
    Gtk::Image *info_barcoderead;
    Gtk::Image *info_morphing;
    Gtk::Image *info_dae;
    Gtk::Image *info_accurate;
    Gtk::Image *info_c2err;
    Gtk::Image *info_cdtext;
    Gtk::Image *info_stream;
    Gtk::Image *info_dvdcprm;
    Gtk::Image *info_dvdcss;
    Gtk::Image *info_microcode;
    Gtk::Image *info_testwr;
    Gtk::Image *info_smart;
    Gtk::Image *info_defectmng;
    Gtk::Image *info_pwrmng;
    //media
    Gtk::Label *media_disctype;
    Gtk::Label *media_booktype;
    Gtk::Label *media_mid;
    Gtk::Label *media_state;
    Gtk::Label *media_lastses;
    Gtk::Label *media_burner;
    Gtk::Label *media_totalsize;
    Gtk::Label *media_readsize;
    Gtk::Label *media_freesize;
    Gtk::Label *media_erasable;
    Gtk::Label *media_layers;
    Gtk::Label *media_sessions;
    Gtk::Label *media_tracks;
    TracksColumns tracks_columns;
    Glib::RefPtr<Gtk::TreeStore> tracks_store;
    Gtk::TreeView *tracks_view;
    //transfer rate
    Gtk::Label *trate_scantime;
    Gtk::Label *trate_start_d;
    Gtk::Label *trate_start_r;
    Gtk::Label *trate_end_d;
    Gtk::Label *trate_end_r;
    Gtk::Label *trate_avg_d;
    Gtk::Label *trate_avg_r;
    CGraph *trate_curve;
    
    void CreateWidgets(void);

public:
    MainWindow();
    ~MainWindow();
    
    CScan *Scan;

    void on_button_eject_clicked();
    void on_button_start_clicked();
    void on_button_stop_clicked();
    void on_menu_about_clicked();
    void on_drive_changed();
    void on_locked_changed();
    bool on_timeout(int timer_number);
    void on_scan_status();
    
    void ScanBus(void);
    void UpdateDriveInfo(void);
    void UpdateMediaInfo(void);
    void UpdateBookType(void);
    void UpdateDiscType(void);
    
};
#endif //MAIN_WINDOW_H_INCLUDED
