/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * scan_rate.cc
 * Copyright (C) Mike Crash 2008 <mike@mikecrash.com>
 *
 * main.cc is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * main.cc is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <sys/time.h>
#include "scan_rate.h"
#include "drive_tools.h"
#include "const.h"

#define block_dvd 16
#define block_cd  15
#define time_out  13

void CScanRate::test()
{
	block_data	block;
	//block.test = TEST_RATE_RD;
	//post_signal(event_test_init,(void*)TEST);
	int hscale;
	int spinup_time = 4;
	char use_readcd = 0;
	count = 0;

	block.err_total=0; block.err_max=0; block.err_cur=0; block.err_avg=0.0;
	block.lba=0; block.block = 0; block.blocks = drive->media.capacity;
	struct	timeval	blk_tbeg,blk_tend, start, finish;
	int	i,ii;
	float	spd=0;
	int	r1=0,r2=0;
	signal(SSTAT_INIT);
	printf("Starting Read Transfer Rate test on %s...\n", (drive->media.disc_type & DISC_CD) ? "CD" : "DVD");
	if (drive->media.disc_type & DISC_DVD)
	{
		drive->parms.read_speed_kb=-1;
		//set_read_speed(drive);
		size = bufsize / block_dvd * block_dvd;
		r1 = (long long)size * (long long)drive->media.capacity / (long long)sectorsDVD;
		limit = r1;
		hscale = drive->media.capacity / r1;
		max_x = hscaleDVD;
		max_y = 16;
		printf("Blocks: %d %d %d\n",r1, hscale, size);
		signal(SSTAT_SPINUP);
		Drive->wait_unit_ready(time_out);
		Drive->spinup(spinup_time);
		if (stop_) return;
		signal(SSTAT_START);
		gettimeofday(&start, NULL); blk_tbeg = start;
		for (i=0;(i<r1) && (!stop_);i++) 
		{
			for (ii=0;ii<(hscale/block_dvd); ii++) 
			{
				Drive->read(block.lba, block_dvd);
				block.lba+=block_dvd;
			}
			gettimeofday(&blk_tend, NULL);
            // Calculating current speed
			block.time=(blk_tend.tv_sec - blk_tbeg.tv_sec)*1000000 + (blk_tend.tv_usec - blk_tbeg.tv_usec);
			spd=(float)hscale*2/((float)block.time/1000000.0);
			block.idx=i;
			block.block = (i+1)*hscale;
			block.speed_kb= spd;
			block.speed_h = (int)((spd*12.5)/dvd1X);
			block.speed_x = (float)spd/dvd1X;
			block.time=(blk_tend.tv_sec - start.tv_sec);
			block.pit=0;
			printf("LBA: %7d / %7d (idx%3d) %5.2fkB/s (%3.2fx)\r", block.lba, drive->media.capacity, block.idx, spd,spd/dvd1X);
			blk_tbeg = blk_tend;
			buffer[i] = block.speed_x;
			if (i==0)
			{
				start1 = block.speed_x;
				start2 = block.speed_kb;
			}
			end1 = block.speed_x;
			end2 = block.speed_kb;
            // Calculating average speed
			finish = blk_tend;
			block.time=(finish.tv_sec - start.tv_sec)*1000000 + (finish.tv_usec - start.tv_usec);
			spd=(float)(i+1)*hscale*2/((float)block.time/1000000);
			block.time/=1000000;
			block.speed_kb= spd;
			block.speed_x = (float)spd/dvd1X;
			block.pit=1;
			avg1 = block.speed_x;
			avg2 = block.speed_kb;
			scantime = block.time;
			count++;
			signal(SSTAT_UPDATE);
		}
	} 
	else if (drive->media.disc_type & DISC_CD) 
	{
		if (drive->capabilities & CAP_DAE) use_readcd = 1;
		drive->parms.read_speed_kb=-1;
		//set_read_speed(drive);
		size = bufsize / block_cd * block_cd;
		r1 = size * drive->media.capacity / sectorsCD;
		limit = r1;
		hscale = drive->media.capacity / r1;
		max_x = hscaleCD;
		max_y = 56;
		printf("Blocks: %d - %d - %d\n", r1, size, hscale);
		signal(SSTAT_SPINUP);
		Drive->wait_unit_ready(time_out);
		Drive->spinup(spinup_time);
		if (stop_) return;
		signal(SSTAT_START);
		gettimeofday(&start, NULL); blk_tbeg = start;
		Drive->seek(0);
		for (i=0;(i<r1) && (!stop_);i++) 
		{
			for (ii=0;ii<(hscale/block_cd); ii++) 
			{
				if (use_readcd)
					Drive->read_cd(block.lba, block_cd, 0xF8);
				else
					Drive->read(block.lba, block_cd);
				block.lba+=block_cd;
				if (drive->err) 
					return;
			}
			gettimeofday(&blk_tend, NULL);
            // Calculating current speed
			block.time=(blk_tend.tv_sec - blk_tbeg.tv_sec)*1000000 + (blk_tend.tv_usec - blk_tbeg.tv_usec);
			spd=(float)hscale*2/((float)block.time/1000000.0);
			block.idx=i;
			block.block = (i+1)*hscale;
			block.speed_kb= spd;
			block.speed_h = (int)(spd*5/cd1X);
			block.speed_x = (float)spd/cd1X;
			block.time=(blk_tend.tv_sec - start.tv_sec);
			block.pit=0;
			printf("LBA: %7d / %7d (idx %3d) %5.3fkB/s (%3.2fx)\r", block.lba, drive->media.capacity, block.idx, spd, spd/cd1X);
			blk_tbeg = blk_tend;
			buffer[i] = block.speed_x;
			if (i==0)
			{
				start1 = block.speed_x;
				start2 = block.speed_kb;
			}
			end1 = block.speed_x;
			end2 = block.speed_kb;
            // Calculating average speed
			finish = blk_tend;
			block.time=(finish.tv_sec - start.tv_sec)*1000000 + (finish.tv_usec - start.tv_usec);
			spd=(float)(i+1)*hscale*2/((float)block.time/1000000);
			block.time/=1000000;
			block.speed_kb= spd;
			block.speed_x = (float)spd/cd1X;
			block.pit=1;
			avg1 = block.speed_x;
			avg2 = block.speed_kb;
			scantime = block.time;
			count++;
			signal(SSTAT_UPDATE);
		}
	}
	printf("\n");
	if (stop_)
		signal(SSTAT_ABORT);
	else
		signal(SSTAT_DONE);
}
