/*
 * This file is part of the QPxTool project.
 * Copyright (C) 2005-2006 Gennady "ShultZ" Kozlov <qpxtool@mail.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#include <stdio.h>
#include "scan.h"

CScan::CScan()
:
  thread_   (0),
  buffer    (NULL),
  count     (0),
  size      (0),
  bufsize   (1000)
{
  if(!Glib::thread_supported()) 
    Glib::thread_init();
}

CScan::~CScan()
{
  //stop the thread if running
  if (thread_ != NULL)
  {
    stop();
    join();
  }
}

int CScan::id() const
{
  return id_;
}

void CScan::run()
{
  // Create a joinable thread.
  stop_ = false;
  thread_ = Glib::Thread::create(sigc::mem_fun(*this, &CScan::thread_function), true);
}

void CScan::join()
{
  thread_->join();
  //thread_ = 0;
}

void CScan::stop()
{
  stop_ = true;
  //join();
}

bool CScan::unfinished() const
{
  return false;
}

void CScan::signal(int status)
{
    signal_status = status;
    signal_dispatcher();
}

void CScan::thread_function()
{
  count = 0;
  size = 0;
  if (buffer)
    delete buffer;
  buffer = new float[bufsize];
  test();
}

void CScan::set_drive(drive_info* drv)
{
    drive = drv;
}

int CScan::get_count(void)
{
    return count;
}

int CScan::get_size(void)
{
    return size;
}

int CScan::get_limit(void)
{
    return limit;
}

void CScan::set_size(int sz)
{
    if (buffer == NULL)
        bufsize = sz;
}

float CScan::get_max_x(void)
{
    return max_x;
}

float CScan::get_max_y(void)
{
    return max_y;
}

float* CScan::get_buffer()
{
    return buffer;
}

float CScan::get_start1(void)
{
    return start1;    
}

float CScan::get_start2(void)
{
    return start2;    
}

float CScan::get_end1(void)
{
    return end1;    
}

float CScan::get_end2(void)
{
    return end2;    
}

float CScan::get_avg1(void)
{
    return avg1;    
}

float CScan::get_avg2(void)
{
    return avg2;    
}

int CScan::get_scantime(void)
{
    return scantime;
}
