/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * graph.h
 * Copyright (C) Mike Crash 2008 <mike@mikecrash.com>
 *
 * main.cc is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * main.cc is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GOT_GRAPH_H
#define GOT_GRAPH_H

#include <gtkmm/drawingarea.h>

class CGraph : public Gtk::DrawingArea
{
public:
  CGraph();
  virtual ~CGraph();
  
  void draw_graph(float *buf, int cnt, int total);
  void set_limits(float x1, float x2, float y1, float y2);
  void set_units(const char *x, const char *y);
  void set_maxcnt(int cnt);
  
protected:
  //Override default signal handler:
  virtual bool on_expose_event(GdkEventExpose* event);

private:
  int count;
  int size;
  int limit;
  float min_x;
  float max_x;
  float roof_x;
  char *unit_x;
  float min_y;
  float max_y;
  char *unit_y;
  float *buffer;
  
  int offset_x;
  int offset_y;
  
  void draw(Cairo::RefPtr<Cairo::Context> cr, float *buf, int cnt, int total);
  void draw_axes(Cairo::RefPtr<Cairo::Context> cr);
};

#endif // GOT_GRAPH_H
