/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * drive_tools.h
 * Copyright (C) Mike Crash 2008 <mike@mikecrash.com>
 * 
 * drive_tools.h is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * drive_tools.h is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _DRIVE_TOOLS_H_
#define _DRIVE_TOOLS_H_

#define MAX_DRIVES 20

#include "scsi_mmc.h"
#include "scsi_command.h"

const unsigned int	bufsz_dev  = 0x0000FF;
const unsigned int	bufsz_rd   = 0x010000;
const unsigned int	bufsz_ATIP = 0x000800;

class	drive_info {
public:
	drive_info();
	drive_info(const char* _device);
	~drive_info();

	Scsi_Command	cmd;

	void	cmd_clear();
	int	err;

	char*	device;		// device adress
	char	ven[9];		// vendor string
	int	ven_ID;		// drive vendor ID
	char	dev[17];	// model string
	int	dev_ID;		// model ID
	char	fw[5];		// FirmWare
	char	serial[17];	// drive serial#
	char	TLA[5];		// TLA# - only rof Plextor PX-712, PX-716

	int	z;

	unsigned int	buffer_size;	 // drive buffer size
	unsigned int	capabilities;	 // common capabilities
	unsigned int	rd_capabilities; // read capabilities
	unsigned int	wr_capabilities; // write capabilities
	unsigned int	ven_features;	// vendor-specific features
	unsigned int	chk_features;	// media check features

	unsigned int	iface_id;
	str_if		iface;
	unsigned int	loader_id;

	short		book_plus_r;
	short		book_plus_rw;
	short		book_plus_rdl;

	plex_features	plextor;
	plex_as		astrategy;
	plex_silent	plextor_silent;
	pio_quiet	pioneer;
	media_info	media;
	drive_parms	parms;
	perf_desc	perf;

	unsigned char*	rd_buf;
	unsigned char*	ATIP;
	int		ATIP_len;
	char		mmc;

	rpc_state	rpc;

	char		silent;
private:
	bool		busy;
};


class DriveTools
{
public:
    int         drvcnt;
    char*       drives[MAX_DRIVES];
	char	    device[32];
	char	    drvtbl[_devcnt][32];
	drive_info*	drive;

	DriveTools(void);
	~DriveTools(void);

	void ScanBus(void);
	void SetDrive(int drvnum);
	void Eject(void);
	
    int inquiry(void);
    int test_unit_ready(void);
    int wait_unit_ready(int secs, bool need_media=1);
    int request_sense(char add);
    void read_rpc_state(void);
    void read_disc_regions(void);
    int get_configuration(int feature_number, unsigned int* data_length, int* current, unsigned char ReqType);
    void detect_iface(void);

    int get_profiles_list(void);
    int get_features_list(void);
    int get_mode_pages_list(void);
    void detect_capabilities(void);

    int read_atip(void);
    int read_toc(void);
    int read_track_info(trk* track, unsigned int track_n);
    int get_track_list(void);
    int read_capacity(void);
    int read_free(void);
    int read_disc_information(void);
    int convert_to_ID (void);
    int determine_cd_type(void);
    // int determine_cdrw_subtype(void);
    int read_mediaid_cd(void);
    int read_mediaid_dvd(void);
    int determine_disc_type(void);
    int mode_sense(int page, int page_control, int dest_len);
    int mode_select(int dest_len);

    int get_spindown(void);
    int set_spindown(void);
    int get_performance(void);
    int get_write_speed(void);
    int get_write_speed_tbl(void);
    int get_read_speed(void);
    int set_streaming(void);
    int set_read_speed(void);
    int get_media_status(void);
    int load_eject(bool load);
    int get_lock(void);
    int set_lock(void);

    // void spinup(void);
    void spinup(unsigned char secs = 2);
    int seek(int lba, unsigned char flags = 0);
    int play_audio_msf(int beg, int end);
    int play_audio(int beg, short int len);
    int read_cd(int lba, int sector_count, unsigned char flags, unsigned char FUA = 0);
    int read(int lba, int sector_count, unsigned char FUA = 0);
    int read_one_ecc_block(int lba);
    int get_drive_serial_number(void);
    int read_buffer_capacity(void);
    int read_writer_info(void);
    int set_cd_speed(void) ;

    int detect_mm_capabilities(void);
    int detect_check_capabilities(void);

protected:

private:


};

extern DriveTools *Drive;

#endif // _DRIVE_TOOLS_H_
