/***************************************************************************************/
/*                                                                                     */
/*  Girder 3.0 Plugin                                                                  */
/*  DLL implementaion                                                                  */
/*                                                                                     */
/*  Copyright 2000 (c) Ron Bessems                                                     */
/*  GNU General Public License                                                         */
/*                                                                                     */
/*  you must implement the functions marked with __declspec(dllexport) at the least    */
/*  Girder expects these                                                               */
/*                                                                                     */
/*                                                                                     */
/*                                                                                     */
/*  The mutex is probably overdone in this example but beter to be safe that sorry     */
/*                                                                                     */
/*                                                                                     */
/***************************************************************************************/

#define UIRFILE	



#include "uir.h"
#include <string.h>
#include <stdio.h>
#include <malloc.h>
#include "ui.h"
#include "ircom.h"
#include "settings.h"


/* Used to prevent simulatious reading and writing in the buffer from Girder and the DLL-- MUST BE UNIQUE */
#define HOOKMUTEXNAME          "UIRARC2000Mutex"
/* Probably doesn't happen but just to be sure */

/* Shared DATA, available in all contexts, they must be initialized for this to work */
// #pragma data_seg(".SHARDATA")
static HWND hTargetWindow=0;
static UINT Message=0;
static CHAR Buffer[16]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static bool Running=FALSE;
// #pragma data_seg()

typedef bool (_stdcall *TPluginCallBack)(TKeyCode buf, DWORD size);
TPluginCallBack PluginCallBack;



HANDLE HookMutex;	 /* This is separate for each context */
bool Terminate=TRUE; /* Set to true if the IR thread should exit */ 

HANDLE IRThreadHandle=0;
HANDLE ConfigThreadHandle=0;

/* The main thread that polls for a IR event, look at keyboard.dll for 
	a callback implementation */

DWORD WINAPI IRThread( LPVOID lpParameter )
{
	bool StopThread=FALSE;
	bool send=FALSE;
	UINT i,b;


	while ( !StopThread ) 
	{
		Sleep(50);		
		WaitForSingleObject(HookMutex,INFINITE);
		StopThread=Terminate;
		if (StopThread)
		{
			ReleaseMutex(HookMutex);	
			return 0;
		}

		send=readIR(Buffer, 15);


		if ( StripZeros && send )
		{
			for (i=0; i< strlen(Buffer); i++)
			{
				if ( Buffer[i]!='0' )
				{
					b=i; 
					break;
				}
			}
			


			for (i=b; i< strlen(Buffer); i++)
			{
				Buffer[i-b]=Buffer[i];
			}

			for (i=strlen(Buffer)-1; i>=0 ; i--)
			{
				if (Buffer[i]!='0')
				{
					b=i;
					break;
				}
			}


			Buffer[b+1]=0;
		}


		
		if (Terminate)
		{

			ReleaseMutex(HookMutex);	
	
			return 0;
		}


		ReleaseMutex(HookMutex);	
		if (send)
		{

//          MessageBox(0, "Key pressed", "Send", MB_OK);
//	      strncpy(KeyBuf, Buffer,16);
    	  PluginCallBack((TKeyCode)&Buffer,strlen(Buffer));
		}

	}

    
	return 0;
}

/* Only export the function if you need to 
__declspec(dllexport) void learn_device(PCHAR *old)
{
	
}
*/


//************************* HW Init ****************************
__declspec(dllexport) bool _stdcall HWInit()
{
   DWORD dwThreadId;
   
   if ( Running )
   {
		return TRUE;
   }

   WaitForSingleObject(HookMutex,INFINITE);   

   if (!(power_up(ComPort,FastInit,SkipInit)))
   {
	   ReleaseMutex(HookMutex);
	   return FALSE;
   }

   settimeouts(IRSpeed);

   Terminate=FALSE;

   IRThreadHandle=CreateThread(NULL,0,&IRThread,hInstance,0,&dwThreadId);
   if (IRThreadHandle==0)
   {
      MessageBox(0, "Cannot create IRThread.", "Error", MB_OK);
	  Terminate=TRUE;
	  ReleaseMutex(HookMutex);	
	  return FALSE;
   }

   ReleaseMutex(HookMutex);	
   Running=TRUE;
   return TRUE;
}

//************************* HW DeInit ****************************
__declspec(dllexport) bool _stdcall HWDeInit()
{
	if (!Running)
	{
		return TRUE;
	}
	WaitForSingleObject(HookMutex,INFINITE);	
	Terminate=TRUE;
	ReleaseMutex(HookMutex);	

	/* Give the thread a chance to grab the mutex */
	/* The thread mutex is only released when the thread is finished */
	WaitForSingleObject(IRThreadHandle, INFINITE); 
	CloseHandle(IRThreadHandle);

	WaitForSingleObject(HookMutex,INFINITE);	
	power_down();
	ReleaseMutex(HookMutex);	
	Running=FALSE;
	return TRUE;
}


bool flush_device()
{
			
	resetcom();
	return TRUE;
}


__declspec(dllexport) bool _stdcall ConfigurationDialog()
{
   DWORD dwThreadId;
   
   if (hWindow != 0)   
   {
      SetForegroundWindow(hWindow);
   }
   else
   {
      ConfigThreadHandle=CreateThread(NULL,0,&ConfigThread,hInstance,0,&dwThreadId);
      if (ConfigThreadHandle==0)
         MessageBox(0, "Cannot create dialogthread.", "Error", MB_OK);
    
   }

 
   return TRUE;
}



/*__declspec(dllexport)*/ bool compare_str(PCHAR Orig,PCHAR Comp)
{
	return (strcmp(Orig, Comp)==0);
}


/* Called when Girder calls LoadLibrary */
void init_dll()
{
    /* Create the mutex */
	HookMutex=CreateMutex(NULL,TRUE,HOOKMUTEXNAME);
	ReleaseMutex(HookMutex);
}


/* Called when Girder called FreeLibrary */
void close_dll()
{
    WaitForSingleObject(HookMutex,INFINITE);
    ReleaseMutex(HookMutex);
    CloseHandle(HookMutex);
}


//************************* Remote Info ****************************
__declspec(dllexport) BOOL _stdcall GetRemoteInfo(PRemoteInfo RemoteInfo)
{
   RemoteInfo->Size=sizeof(TRemoteInfo);
   memcpy(RemoteInfo->Name,"UIR PIC Remote",15);
   memcpy(RemoteInfo->Version,"version 1.02",13);
   RemoteInfo->Flags=RF_CALLBACK | RF_CONFIGUREDIALOG;
   return(true);
}

//************************* SetCallback ****************************
__declspec(dllexport) BOOL _stdcall SetCallback(TPluginCallBack CallBack)
{
   if (CallBack==NULL) return(false);
  PluginCallBack=CallBack;
  return(true);
}

/* Called by windows */
BOOL WINAPI DllMain( HANDLE hModule, 
                        DWORD fdwreason,  LPVOID lpReserved )
{

	switch(fdwreason) {
    case DLL_PROCESS_ATTACH:
		hInstance=HINSTANCE(hModule);
		init_dll();
    break;
    case DLL_THREAD_ATTACH:
    break;
    case DLL_THREAD_DETACH:
    break;
    case DLL_PROCESS_DETACH:
		close_dll();
    break;
    }
    return TRUE;
}

