/***************************************************************************************/
/*                                                                                     */
/*  Girder 3.0 Plugin                                                                  */
/*  Serial Communications interface                                                    */
/*                                                                                     */
/*  Copyright 2000 (c) Ron Bessems                                                     */
/*  GNU General Public License                                                         */
/*                                                                                     */
/*                                                                                     */
/***************************************************************************************/


/* Get rid of the M($)FC */
#define WIN32_LEAN_AND_MEAN

#include <windows.h>
#include <winbase.h>
#include <stdio.h>

HANDLE com=0;
// #define SILENT

bool settimeouts(int speed)
{
  COMMTIMEOUTS to;
  
  if (com==0)
		return FALSE;


  to.ReadIntervalTimeout=2;
  to.ReadTotalTimeoutConstant=speed;
  to.ReadTotalTimeoutMultiplier=10;
  to.WriteTotalTimeoutConstant=2;
  to.WriteTotalTimeoutMultiplier=2;
  return (!(SetCommTimeouts(com, &to)==0));

}



bool opencom(int port)
{
	PCHAR comport;

	switch (port) 
	{
	case 1: comport="COM1"; break;
	case 2: comport="COM2"; break;
	case 3: comport="COM3"; break;
	case 4: comport="COM4"; break;
	case 5: comport="COM5"; break;
	case 6: comport="COM6"; break;
	case 7: comport="COM7"; break;	
	case 8: comport="COM8"; break;
	}

	com=CreateFile(comport,GENERIC_READ | GENERIC_WRITE,0,NULL,OPEN_EXISTING,
							FILE_ATTRIBUTE_NORMAL,0);

	if (com==NULL) 
		return FALSE;

	
	return settimeouts(100);

}
    
bool closecom()
{
	if (com==0)
		return TRUE;

	if (CloseHandle(com)) 
	{
		com=0;
		return TRUE;
	}
	return FALSE;

}


bool setcom(int rate)
{
	DCB dcb;
	char buffer[255];

	if (com==0)
		return FALSE;

	if (GetCommState(com, &dcb)==0)
		return FALSE;

	sprintf(buffer, "baud=%d parity=N data=8 stop=1 to=off xon=off odsr=off octs=off dtr=off rts=off idsr=off", rate);

	if (BuildCommDCB(buffer,&dcb)==0)
	{
		return FALSE;		
	}


	if (SetCommState(com, &dcb)==0)
		return FALSE;

	return TRUE;
}


bool powerUIR(bool ON)
{
	bool res=TRUE;

	if (com==0)
		return FALSE;


	switch (ON)
	{
	case TRUE:
		res=res & (!(EscapeCommFunction(com,SETDTR)==0));
		res=res & (!(EscapeCommFunction(com,SETRTS)==0));
		break;
	case FALSE:
		res=res & (!(EscapeCommFunction(com,CLRDTR)==0));
		res=res & (!(EscapeCommFunction(com,CLRRTS)==0));
		break;
	}
	return res;

}

		
bool readb_com(BYTE &buf)
{
	DWORD num;
	char b;
	if (com==0)
		return FALSE;

	if (ReadFile(com, &b, 1, &num, NULL)==0)
		return FALSE;

	buf=b;

	if (!(num==1))
	{
		return FALSE;
	}
	return TRUE;

}


bool writeb_com(BYTE buf)
{
	DWORD num;

	if (com==0)
		return FALSE;

	if (WriteFile(com, &buf, 1, &num, NULL)==0)
		return FALSE;

	if (!(num==1))
	{
		return FALSE;
	}
	return TRUE;
	

}


bool reada_com(PCHAR buffer, int &len)
{
	DWORD num;	

	if (com==0)
		return FALSE;

	if (ReadFile(com, buffer, len, &num, NULL)==0)
		return FALSE;

	len=num;

	return TRUE;

}


bool resetcom()
{
	if (com==0)
		return FALSE;
	
	PurgeComm(com, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR);
	
	return TRUE;
}



/* UIR/IRman */

bool readIR(PCHAR buffer, int len)
{
	char buf[20];
	int leng;
	int i;
	BYTE o,h,l;
	
	if (len<13) return FALSE;
	
	leng=6;

	if (!(reada_com(buf, leng)))
		return FALSE;

	if ( leng==0 )
		return FALSE;

	/* Convert to Hex */
	for (i=0;i<6;i++)
	{
		o= buf[i];
		h= o / 16;
		l= o % 16;
					
		if ( h < 10 ) 
			buffer[i*2]=char(h+48);
		else
			buffer[i*2]=char(h+55);

		if ( l < 10 )
			buffer[(i*2)+1]=char(l+48);
		else	
			buffer[(i*2)+1]=char(l+55);
	}
	
	buffer[12]=0;
	return TRUE;
}


bool power_up(int port, bool fast, bool skipinit)
{
	BYTE buf;
	
	if (!opencom(port))
	{
#ifndef SILENT
		MessageBox(0, "Cannot open Comport.", "Error", MB_OK);
#endif
		return FALSE;
	}

	if (!setcom(9600))
	{
#ifndef SILENT
		MessageBox(0, "Cannot set comport speed.", "Error", MB_OK);
#endif
		closecom();
		return FALSE;
	}

	if (!powerUIR(FALSE))
	{
#ifndef SILENT
		MessageBox(0, "Cannot power down.", "Error", MB_OK);
#endif
		closecom();
		return FALSE;
	}

	if (fast)
		Sleep(250);
	else
		Sleep(500);

	if (!powerUIR(TRUE))
	{
#ifndef SILENT
		MessageBox(0, "Cannot power up.", "Error", MB_OK);
#endif
		closecom();
		return FALSE;
	}

	if (fast)
		Sleep(250);
	else
		Sleep(500);
	
resetcom();	

	if (!writeb_com('I'))
	{
#ifndef SILENT
		MessageBox(0, "Cannot write I.", "Error", MB_OK);
#endif
		closecom();
		return FALSE;
	}



	if (fast)
		Sleep(2);
	else
		Sleep(500);



	if (!writeb_com('R'))
	{
#ifndef SILENT
		MessageBox(0, "Cannot write R.", "Error", MB_OK);
#endif
		closecom();
		return FALSE;
	}

	if ( skipinit ) 
	{
		Sleep(500);
		resetcom();
		return TRUE;
	}

	if (fast)
		Sleep(100);
	else
		Sleep(500);

	if (!readb_com(buf))
	{
#ifndef SILENT
		MessageBox(0, "Cannot read 1st char.", "Error", MB_OK);
#endif
		closecom();
		return FALSE;		
	}
	
	if (!(buf=='O'))
	{
#ifndef SILENT
		MessageBox(0, "Incorrect 1st char .", "Error", MB_OK);
#endif
		closecom();
		return FALSE;		
	}
		
	if (!readb_com(buf))
	{
#ifndef SILENT
		MessageBox(0, "Cannot read 2nd char.", "Error", MB_OK);
#endif
		closecom();
		return FALSE;		
	}
	
	if (!(buf=='K'))
	{
#ifndef SILENT
		MessageBox(0, "Incorrect 2nd char .", "Error", MB_OK);
#endif
		closecom();
		return FALSE;		
	}

	return TRUE;

}



bool power_down()
{

	if (com==0)
		return FALSE;
		

	if (!(powerUIR(FALSE)))
	{
#ifndef SILENT
		MessageBox(0, "Cannot power down.", "Error", MB_OK);
#endif
		return FALSE;		
	}


	closecom();
	return TRUE;

}
